<?php
/* --------------------------------------------------------------
 HubServiceProvider.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace GXModules\Gambio\Hub\Admin\Plugin;

use Gambio\Core\Application\Plugins\Abstraction\AbstractPluginServiceProvider;
use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Configuration\Builder\ConfigurationFinderBuilder;
use Gambio\Core\Language\TextManager;

/**
 * Class HubServiceProvider
 * @package GXModules\Gambio\Hub\Admin\Plugin
 */
class HubServiceProvider extends AbstractPluginServiceProvider
{
    /**
     * @return array
     */
    public function provides(): array
    {
        return [HubLoadLayoutDataHandler::class];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(HubLoadLayoutDataHandler::class)->addArgument(HubFooterBadgeLoader::class);
        
        $this->application->share(HubFooterBadgeLoader::class)
                          ->addArgument(ConfigurationFinderBuilder::class)
                          ->addArgument(TextManager::class)
                          ->addArgument(Url::class)
                          ->addArgument(Path::class);
    }
}